/* kamikaze.c
  All functions for independent kamikaze
  by....Wonderslug
*/
#include        "g_local.h"
#include		"kamikaze.h"

void Start_Kamikaze_Mode(edict_t *self); // setup and start self destruct mode
qboolean		Kamikaze_Active(edict_t *self);
void Kamikaze_Explode(edict_t *self);
void Kamikaze_Cancel(edict_t *self);
void Kamikaze_think(edict_t *self);

/*
Function: Start_Kamikaze_Mode
  Places the edict passed to it into Kamikaze Mode
 (probably best to pass a player to it)
  Warns everyone that so and so is a kamikaze...
*/
void Start_Kamikaze_Mode(edict_t *self){
     
	if (self->client->pers.spectator == SPECTATING) {
		return;
    }
	/* see if we are already in  kamikaze mode*/
	if (self->client->kamikaze_mode & 1)  {

		gi.cprintf(self, PRINT_MEDIUM, "Already in Kamikaze Mode!! Kiss you butt Goodbye!");
		return;		    
	}
	/* dont run if in god mode  */
	if (self->flags & FL_GODMODE){
		gi.cprintf(self, PRINT_MEDIUM, "Can't Kamikaze in God Mode, Whats the Point?");
		return;
	}
	/* not in kamikaze mode yet */
	self->client->kamikaze_mode = 1;
	/*  Give us only so long */
	self->client->kamikaze_timeleft = KAMIKAZE_BLOW_TIME;
	self->client->kamikaze_framenum = level.framenum + self->client->kamikaze_timeleft;
    
    if	(self->client->kamikaze_timeleft < 1);
	return;
    
	/* Warn the World */
	gi.bprintf (PRINT_MEDIUM,"%s is a Kamikaze - BANZAI!!\n", self->client->pers.netname);
    gi.sound( self, CHAN_WEAPON, gi.soundindex("makron/rail_up.wav"), 1, ATTN_NONE, 0 );
	return;
	if (self->client->kamikaze_timeleft >1);
//    self->flags &= ~FL_GODMODE;
    self->health = 0;
	meansOfDeath = MOD_KAMIKAZE;
	player_die (self, self, self, 1, vec3_origin, 0, 0);
}
/* 
Function: Kamikaze_Active
	Are we in Kamikaze Mode? 
	a helper function to see if we are running in Kamikaze Mode
*/
qboolean Kamikaze_Active(edict_t *self){	
return (self->client->kamikaze_mode);
}

/* 
Function: Kamikaze_Cancel
  Canceled for Some Reason
  Call if Player is killed before time is up
*/
void Kamikaze_Cancel(edict_t *self)
{
	/* not in kamikaze mode yet */
	self->client->kamikaze_mode = 0;
	/* Give us only so long */
	self->client->kamikaze_timeleft = 0;
	self->client->kamikaze_framenum = 0;
	return;
}
void Kamikaze_Explode(edict_t *self){
    /* A whole Lotta Damage */ 	
    gi.sound (self, CHAN_AUTO, gi.soundindex("world/explosion1.wav"), 1, ATTN_NORM, 0);
    T_RadiusDamage (self, self, KAMIKAZE_DAMAGE, NULL, KAMIKAZE_DAMAGE_RADUIS, MOD_KAMIKAZE);
     /* BANG ! and show the clients */	 
     gi.WriteByte (svc_temp_entity);
     gi.WriteByte (TE_ROCKET_EXPLOSION);
     gi.WritePosition(self -> s.origin);
     gi.multicast (self->s.origin, MULTICAST_PVS);
	 
}
